/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.servlet.util;

import com.ibm.hwmca.fw.servlet.taskcontroller.TaskControllerQueue;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.ui.bonsai.BonsaiUIStyle;
import java.util.Iterator;

public class UIRefreshManager {
    public static final int RESYNC_CLIENT_REFRESH_TYPE = 0;
    public static final int SETTINGS_CHANGED_REFRESH_TYPE = 1;
    public static final int TABLE_CHANGED_REFRESH_TYPE = 2;
    public static final int TREE_CHANGED_REFRESH_TYPE = 3;
    public static final int TREE_SELECTION_CHANGED_REFRESH_TYPE = 4;
    public static final int STATUS_OVERVIEW_CHANGED_REFRESH_TYPE = 5;
    public static final int SYSTEM_HEALTH_CHANGED_REFRESH_TYPE = 6;
    public static final int TASKBAR_CHANGED_REFRESH_TYPE = 7;
    public static final String REFRESH_TYPE_PARAM_NAME = "refresh_type";
    public static final String UNIQUE_REQUEST_PARAM_NAME = "unique_req_key";
    private static int uniqueParmCounter = 0;

    private UIRefreshManager() {
    }

    public static void refresh(int type, HMCSession hmcSession) {
        String refreshTypeParam = "refresh_type=" + type + "&" + UNIQUE_REQUEST_PARAM_NAME + "=" + uniqueParmCounter++;
        switch (type) {
            case 0: 
            case 1: {
                UIRefreshManager.refreshFrame(null, "init.do", refreshTypeParam, hmcSession);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                UIRefreshManager.refreshFrame("frames['workarea_frame']", "workarea.do", refreshTypeParam, hmcSession);
                break;
            }
            case 3: {
                UIRefreshManager.refreshFrame("frames['navigation_frame']", "navigation.do", refreshTypeParam, hmcSession);
                break;
            }
            case 6: {
                UIRefreshManager.refreshFrame("frames['health_frame']", "health.do", refreshTypeParam, hmcSession);
                break;
            }
            case 7: {
                UIRefreshManager.refreshFrame("frames['taskbar_frame']", "taskbar.do", refreshTypeParam, hmcSession);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type of refresh requested!");
            }
        }
    }

    public static void refresh(int type) {
        Iterator i = BonsaiUIStyle.getActiveBonsaiHMCSessions().iterator();
        while (i.hasNext()) {
            UIRefreshManager.refresh(type, (HMCSession)i.next());
        }
    }

    public static void resizeFrame(HMCSession hmcSession, String frameset_ID, String rowsValue) {
        TaskControllerQueue queue = TaskControllerQueue.getTaskControllerQueue(hmcSession);
        queue.sendScript("top.window.frames['hmcmainui'].document.getElementById('" + frameset_ID + "').rows='" + rowsValue + "';");
    }

    public static void refreshFrame(String frame, String newLocation, String requestParms, HMCSession hmcSession) {
        requestParms = requestParms != null ? "?" + requestParms : "";
        if (frame == null) {
            frame = "";
        }
        if (frame.length() > 0 && !frame.startsWith(".")) {
            frame = "." + frame;
        }
        TaskControllerQueue queue = TaskControllerQueue.getTaskControllerQueue(hmcSession);
        queue.sendScript("top.window.frames['hmcmainui']" + frame + ".location.href='" + "/hmc/ui/bonsai/" + newLocation + requestParms + "';");
    }

    public static void refreshFrame(String frame, String newLocation, String requestParms) {
        Iterator i = BonsaiUIStyle.getActiveBonsaiHMCSessions().iterator();
        while (i.hasNext()) {
            UIRefreshManager.refreshFrame(frame, newLocation, requestParms, (HMCSession)i.next());
        }
    }
}

